// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)
    based on code by Marc Shapiro (shapiro@sor.inria.fr)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _CObXPlex_h
#ifdef __GNUG__
#pragma interface
#endif
#define _CObXPlex_h 1

#include "COb.Plex.h"

class CObXPlex: public CObPlex
{
  CObIChunk*       ch;           // cached chunk

  void             make_initial_chunks(int up = 1);

  void             cache(int idx) const;
  void             cache(const COb* p) const;

  COb*             dopred(const COb* p) const;
  COb*             dosucc(const COb* p) const;

  inline void             set_cache(const CObIChunk* t) const; // logically, 
                                               // not physically const
public:
                   CObXPlex();                 // set low = 0;
                                               // fence = 0;
                                               // csize = default

                   CObXPlex(int ch_size);      // low = 0; 
                                               // fence = 0;
                                               // csize = ch_size

                   CObXPlex(int lo,            // low = lo; 
                            int ch_size);      // fence=lo
                                               // csize = ch_size

                   CObXPlex(int lo,            // low = lo
                            int hi,            // fence = hi+1
                            const COb  initval,// fill with initval,
                            int ch_size = 0);  // csize= ch_size
                                               // or fence-lo if 0

                   CObXPlex(const CObXPlex&);
  
  void             operator= (const CObXPlex&);

// virtuals


  inline COb&             high_element ();
  inline COb&             low_element ();

  inline const COb&       high_element () const;
  inline const COb&       low_element () const;

  inline Pix              first() const;
  inline Pix              last() const;
  inline void             prev(Pix& ptr) const;
  inline void             next(Pix& ptr) const;
  int              owns(Pix p) const;
  inline COb&             operator () (Pix p);
  inline const COb&       operator () (Pix p) const;

  inline int              low() const; 
  inline int              high() const;
  inline int              valid(int idx) const;
  inline void             prev(int& idx) const;
  inline void             next(int& x) const;
  inline COb&             operator [] (int index);
  inline const COb&       operator [] (int index) const;
    
  inline int              Pix_to_index(Pix p) const;
  inline Pix              index_to_Pix(int idx) const;    

  inline int              can_add_high() const;
  inline int              can_add_low() const;
  inline int              full() const;

  int              add_high(const COb  elem);
  int              del_high ();
  int              add_low (const COb  elem);
  int              del_low ();

  void             fill(const COb  x);
  void             fill(const COb  x, int from, int to);
  void             clear();
  void             reverse();
    
  int              OK () const; 

};


inline void CObXPlex::prev(int& idx) const
{
  --idx;
}

inline void CObXPlex::next(int& idx) const
{
  ++idx;
}

inline  int CObXPlex::full () const
{
  return 0;
}

inline int CObXPlex::can_add_high() const
{
  return 1;
}

inline int CObXPlex::can_add_low() const
{
  return 1;
}

inline  int CObXPlex::valid (int idx) const
{
  return idx >= lo && idx < fnc;
}

inline int CObXPlex::low() const
{
  return lo;
}

inline int CObXPlex::high() const
{
  return fnc - 1;
}

inline COb& CObXPlex:: operator [] (int idx)
{
  if (!ch->actual_index(idx)) cache(idx);
  return *(ch->pointer_to(idx));
}

inline const COb& CObXPlex:: operator [] (int idx) const
{
  if (!ch->actual_index(idx)) cache(idx);
  return *((const COb*)(ch->pointer_to(idx)));
}

inline  COb& CObXPlex::low_element ()
{
  if (empty()) index_error();
  return *(hd->pointer_to(lo));
}

inline  const COb& CObXPlex::low_element () const
{
  if (empty()) index_error();
  return *((const COb*)(hd->pointer_to(lo)));
}

inline  COb& CObXPlex::high_element ()
{
  if (empty()) index_error();
  return *(tl()->pointer_to(fnc - 1));
}

inline const COb& CObXPlex::high_element () const
{
  if (empty()) index_error();
  return *((const COb*)(tl()->pointer_to(fnc - 1)));
}

inline  int CObXPlex::Pix_to_index(Pix px) const
{
  COb* p = (COb*)px;
  if (!ch->actual_pointer(p)) cache(p);
  return ch->index_of(p);
}

inline  Pix CObXPlex::index_to_Pix(int idx) const
{
  if (!ch->actual_index(idx)) cache(idx);
  return (Pix)(ch->pointer_to(idx));
}

inline Pix CObXPlex::first() const
{
  return Pix(hd->CObIChunk::first_pointer());
}

inline Pix CObXPlex::last() const
{
  return Pix(tl()->CObIChunk::last_pointer());
}

inline void CObXPlex::prev(Pix& p) const
{
  Pix q = Pix(ch->CObIChunk::pred((COb*) p));
  p = (q == 0)? Pix(dopred((const COb*) p)) : q;
}

inline void CObXPlex::next(Pix& p) const
{
  Pix q = Pix(ch->CObIChunk::succ((COb*) p));
  p = (q == 0)? Pix(dosucc((const COb*)p)) : q;
}

inline COb& CObXPlex:: operator () (Pix p)
{
  return *((COb*)p);
}

inline const COb& CObXPlex:: operator () (Pix p) const
{
  return *((const COb*)p);
}

inline void CObXPlex::set_cache(const CObIChunk* t) const
{
  ((CObXPlex*)(this))->ch = (CObIChunk*)t;
}

#endif
